
#import <Foundation/NSObject.h>


typedef enum	{
    BINDING_READ_WRITE	= 0,
    BINDING_READ_ONLY,
    BINDING_WRITE_ONLY
} BINDING_ACCESS_MODE;



@interface MCBinding:NSObject
{
    id	model;

    id	attribute;
    id	interface;

    id	delegate;

    int	accessMode;
    BOOL mandatoryFlag;
    BOOL tagFlag;
    BOOL listeningToCurrentModel;
}

// FACTORY METHODS

+ (void)initialize;
+ shouldListenToModels:(BOOL)aFlag;

// INSTANCE METHODS

- initForModel:aModel
     attribute:(NSString *)anAttrib
     interface:anInterface
    accessMode:(int)accessMode
 mandatoryFlag:(BOOL)mFlag
       tagFlag:(BOOL)tFlag;

- (void)dealloc;

- copyWithZone:(NSZone *)aZone;

- (BOOL)hasWriteAccess;
- (BOOL)hasReadAccess;
- (BOOL)isMandatory;

// ACCESSOR METHODS

- model;
- leafAttributeModel;
- (void)setModel:aModel;

- (NSString *)attribute;
- (void)setAttribute:(NSString *)anAttribute;

- (NSString *)attributeName;

- interface;
- (void)setInterface:anInterface;

- delegate;
- (void)setDelegate:(id)aDelegate;

- takeValueFromMessageSender;

// MOVING VALUES BETWEEN THE MODEL AND THE UI

- interfaceValue;
- modelValue;

- (void)updateModelFromInterface;
- (void)updateInterfaceFromModel;

- (BOOL)isIncompleteMandatoryField;
- (BOOL)isIncompleteField;
- (BOOL)hasInvalidCharacters;


// READING AND WRITING TYPED STREAMS

- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

@end

@interface NSObject (MCBindingSupport)
- binderGetValueUseTags:(BOOL)useTags;
- (void)binderSetValue:aValue useTags:(BOOL)useTags;
- takeValueFromMessageSender;
@end

@interface NSObject (MCBindingDelegate)
- (BOOL)bindingWillUpdate:sender;
- (void)bindingDidUpdate:sender;
@end

